/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.user;

import com.ibm.hwmca.base.settings.user.UserSettingsBean;
import com.ibm.hwmca.fw.settings.user.UIStyleSettings;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.ui.UIStyle;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UIStyleBean
extends UserSettingsBean {
    private boolean m_bAllowUIStyleToggle;
    private String m_sDefaultStyleChoice;
    private ValueDescriptor[] m_vdDefaultStyleChoice;
    private UIStyleSettings settings;
    private UIStyleSettings savedSettings;
    private List uiStyles;
    private Map m_styleNameToIdMap;
    private boolean showAllowed = false;
    private static final String TRACE_MASKT = "HUSUISBT";
    private static final String TRACE_MASKF = "HUSUISBF";
    private static final String TRACE_MASKD = "HUSUISBD";

    public void setAllowUIStyleToggle(boolean b) throws IllegalUserDataException {
        this.m_bAllowUIStyleToggle = b;
        this.settings.setAllowed(this.m_bAllowUIStyleToggle);
    }

    public boolean isAllowUIStyleToggle() {
        return this.m_bAllowUIStyleToggle;
    }

    public ValueDescriptor[] getDefaultStyleChoiceList() {
        return this.m_vdDefaultStyleChoice;
    }

    public void setDefaultStyleChoice(String s) throws IllegalUserDataException {
        this.m_sDefaultStyleChoice = s;
        this.settings.setIdentifier((String)this.m_styleNameToIdMap.get(this.m_sDefaultStyleChoice));
    }

    public String getDefaultStyleChoice() {
        return this.m_sDefaultStyleChoice;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void prepare() {
        Trace.trace(TRACE_MASKF, "-> UIStyleBean.prepare()");
        if (this.uiStyles != null) {
            this.m_vdDefaultStyleChoice = new ValueDescriptor[this.uiStyles.size()];
            this.savedSettings = (UIStyleSettings)this.settings.clone();
            this.init();
            Trace.trace(TRACE_MASKF, "mount prefix is " + this.getMountPrefix());
            if (!this.showAllowed) {
                this.getUserTaskManager().setShown(this.getMountPrefix() + "AllowUIStyleToggle", false);
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIStyleBean.prepare()");
    }

    public void save() {
    }

    private void init() {
        this.m_bAllowUIStyleToggle = this.settings.isAllowed();
        this.m_sDefaultStyleChoice = this.getUIStyleName(this.getCurrentUIStyle());
        this.m_styleNameToIdMap = new HashMap();
        UIStyle style = null;
        String id = null;
        String name = null;
        for (int i = 0; i < this.uiStyles.size(); ++i) {
            style = (UIStyle)this.uiStyles.get(i);
            id = style.getIdentifier();
            name = this.getUIStyleName(style);
            this.m_styleNameToIdMap.put(name, id);
            this.m_vdDefaultStyleChoice[i] = new ValueDescriptor(id, name);
        }
    }

    protected boolean hasSettingsChanged() {
        Trace.trace(TRACE_MASKF, "-> UIStyleBean.hasSettingsChanged()");
        boolean result = false;
        if (this.uiStyles != null) {
            UserTaskManager utm = this.getUserTaskManager();
            utm.storeAllElements();
            Trace.trace(TRACE_MASKF, "old settings " + this.savedSettings);
            Trace.trace(TRACE_MASKF, "new settings " + this.settings);
            result = !this.settings.equals(this.savedSettings);
        }
        Trace.trace(TRACE_MASKF, "<- UIStyleBean.hasSettingsChanged(), result is " + result);
        return result;
    }

    public boolean isAllowedShown() {
        return this.showAllowed;
    }

    public void setShowAllowed(boolean showAllowed) {
        this.showAllowed = showAllowed;
    }

    public void setUserSettings(UIStyleSettings settings) {
        this.settings = settings;
    }

    protected UserSettings getUserSettings() {
        return this.settings;
    }

    protected void resetUserSettings(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "<> UIStyleBean.resetUserSettings()()");
        this.settings = (UIStyleSettings)this.savedSettings.clone();
        this.init();
    }

    public void update(Object object) {
        Trace.trace(TRACE_MASKF, "<> UIStyleBean.update()");
        this.setUserSettings((UIStyleSettings)object);
        this.init();
    }

    protected void updateUserSettings() {
        Trace.trace(TRACE_MASKF, "<> UIStyleBean.updateUserSettings()");
        if (this.uiStyles != null) {
            this.savedSettings = (UIStyleSettings)this.settings.clone();
        }
    }

    void setUIStyles(List uiStyles) {
        this.uiStyles = uiStyles;
    }

    private UIStyle getCurrentUIStyle() {
        Trace.trace(TRACE_MASKF, "-> UIStyleBean.getCurrentUIStyle()");
        UIStyle result = null;
        String id = this.settings.getIdentifier();
        Trace.trace(TRACE_MASKF, "   looking for id " + id);
        for (int i = 0; i < this.uiStyles.size(); ++i) {
            UIStyle uiStyle = (UIStyle)this.uiStyles.get(i);
            Trace.trace(TRACE_MASKF, "   next is is " + uiStyle.getIdentifier());
            if (!uiStyle.getIdentifier().equals(id)) continue;
            result = uiStyle;
            break;
        }
        Trace.trace(TRACE_MASKF, "<- UIStyleBean.getCurrentUIStyle(), result is " + result);
        return result;
    }

    private String getUIStyleName(UIStyle uiStyle) {
        return uiStyle.getUIInfo().getName();
    }
}

